// smart-title-manager/admin.js
jQuery(document).ready(function($) {

    // Logic for the meta box on post edit screens (no change here)
    $('input[name="stm_hide_title"]').on('change', function() {
        if ($(this).is(':checked')) {
            $('.stm-hide-options').slideDown();
        } else {
            $('.stm-hide-options').slideUp();
        }
    });

    // --- NEW LOGIC FOR SETTINGS PAGE ---

    // 1. Handle clicking the "Modify" button to show the edit drawer
    $('.wp-list-table').on('click', '.stm-modify-settings', function(e) {
        e.preventDefault();
        var $button = $(this);
        $button.closest('tr').next('.stm-edit-row').slideToggle(200);
    });

    // 2. Handle clicking the "Cancel" button to hide the edit drawer
    $('.wp-list-table').on('click', '.stm-cancel-edit', function(e) {
        e.preventDefault();
        $(this).closest('.stm-edit-row').slideUp(200);
    });

    // 3. Handle form submission (Save Changes or Show Title) via AJAX
    $('.wp-list-table').on('click', '.stm-update-button', function(e) {
        e.preventDefault();
        
        var $button = $(this);
        var $form = $button.closest('form');
        var $editRow = $form.closest('.stm-edit-row');
        var $displayRow = $editRow.prev('tr');
        
        var postId = $form.data('post-id');
        var task = $button.data('task');

        // Disable button to prevent multiple clicks
        $button.prop('disabled', true).text('Processing...');

        // Collect data for the AJAX request
        var ajaxData = {
            action: 'stm_update_hide_settings',
            nonce: stm_ajax.nonce,
            post_id: postId,
            task: task,
            locations: []
        };
        
        // If updating, get the checked locations
        if (task === 'update') {
            $form.find('input[type="checkbox"]:checked').each(function() {
                ajaxData.locations.push($(this).val());
            });
        }

        // Perform the AJAX request
        $.ajax({
            url: stm_ajax.ajax_url,
            type: 'POST',
            data: ajaxData,
            success: function(response) {
                if (response.success) {
                    // Update the "Hidden In" column in the main display row
                    $displayRow.find('.stm-locations-list').html(response.data.locations_html);
                    
                    // Add visual feedback
                    $displayRow.addClass('stm-row-updated').delay(1500).queue(function() {
                        $(this).removeClass('stm-row-updated').dequeue();
                    });

                    // If all titles are now shown, the row should be removed entirely
                    if (response.data.locations_html === '—') {
                       $displayRow.add($editRow).fadeOut(400, function() {
                           $(this).remove();
                       });
                    } else {
                        // Otherwise, just hide the edit drawer
                        $editRow.slideUp(200);
                    }
                } else {
                    alert('An error occurred: ' + response.data);
                }
            },
            error: function() {
                alert('A server error occurred. Please try again.');
            },
            complete: function() {
                // Re-enable the button and restore text
                $button.prop('disabled', false);
                if (task === 'update') $button.text('Save Changes');
                if (task === 'show') $button.text('Show Title Everywhere');
            }
        });
    });
});